/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.enums.LoginMethod;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class CiscoDeviceEvent
extends IPCEvent {
    public EventType type;

    public CiscoDeviceEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        DONE_BOOTING,
        LINE_CONNECTED,
        LINE_DISCONNECTED,
        LINE_AUTHENTICATION_STARTED,
        LINE_AUTHENTICATION_FAILED,
        LINE_AUTHENTICATION_FINISHED;

    }

    public static class LineAuthenticationFinished
    extends CiscoDeviceEvent {
        public Integer lineNum;
        public Boolean success;

        public LineAuthenticationFinished(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LINE_AUTHENTICATION_FINISHED;
            this.lineNum = (Integer)ltv.getEventParameters().get(0);
            this.success = (Boolean)ltv.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tlineNum = " + this.lineNum + "\n\tsuccess = " + this.success;
        }
    }

    public static class LineAuthenticationFailed
    extends CiscoDeviceEvent {
        public Integer lineNum;

        public LineAuthenticationFailed(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LINE_AUTHENTICATION_FAILED;
            this.lineNum = (Integer)ltv.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tlineNum = " + this.lineNum;
        }
    }

    public static class LineAuthenticationStarted
    extends CiscoDeviceEvent {
        public Integer lineNum;
        public IPAddress srcIp;
        public Short srcTcpPort;
        public LoginMethod loginMethod;

        public LineAuthenticationStarted(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LINE_AUTHENTICATION_STARTED;
            this.lineNum = (Integer)ltv.getEventParameters().get(0);
            this.srcIp = (IPAddress)ltv.getEventParameters().get(1);
            this.srcTcpPort = (Short)ltv.getEventParameters().get(2);
            this.loginMethod = LoginMethod.fromIntValue((Integer)ltv.getEventParameters().get(3));
        }

        public String toString() {
            return super.toString() + "\n\tlineNum = " + this.lineNum + "\n\tsrcIp = " + this.srcIp + "\n\tsrcTcpPort = " + this.srcTcpPort + "\n\tloginMethod = " + (Object)((Object)this.loginMethod);
        }
    }

    public static class LineDisconnected
    extends CiscoDeviceEvent {
        public Integer lineNum;

        public LineDisconnected(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LINE_DISCONNECTED;
            this.lineNum = (Integer)ltv.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tlineNum = " + this.lineNum;
        }
    }

    public static class LineConnected
    extends CiscoDeviceEvent {
        public Integer lineNum;
        public IPAddress srcIp;
        public Short srcTcpPort;
        public LoginMethod loginMethod;

        public LineConnected(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LINE_CONNECTED;
            this.lineNum = (Integer)ltv.getEventParameters().get(0);
            this.srcIp = (IPAddress)ltv.getEventParameters().get(1);
            this.srcTcpPort = (Short)ltv.getEventParameters().get(2);
            this.loginMethod = LoginMethod.fromIntValue((Integer)ltv.getEventParameters().get(3));
        }

        public String toString() {
            return super.toString() + "\n\tlineNum = " + this.lineNum + "\n\tsrcIp = " + this.srcIp + "\n\tsrcTcpPort = " + this.srcTcpPort + "\n\tloginMethod = " + (Object)((Object)this.loginMethod);
        }
    }

    public static class DoneBooting
    extends CiscoDeviceEvent {
        public DoneBooting(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DONE_BOOTING;
        }

        public String toString() {
            return super.toString();
        }
    }
}

